package com.elitesland.yst.emdg.support.provider.price.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/12
 */
@Data
@NoArgsConstructor
@ApiModel(value = "价格中心", description = "价格中心查询")
public class PriPriceRpcDTO implements Serializable {
    private static final long serialVersionUID = -1948926768080959006L;

    @ApiModelProperty("价格唯一标识ID")
    private Long id;

    @ApiModelProperty(value = "价格类型")
    @SysCode(sys = "yst-supp", mod = "PRICE_TYPE")
    private String priceType;
    private String priceTypeName;

    @ApiModelProperty(value = "价格")
    private BigDecimal price;

    @ApiModelProperty(value = "销售组织")
    private String saleOrg;

    @ApiModelProperty(value = "商品编码")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品类型")
    private String itemType2;

    @ApiModelProperty(value = "基本计量单位")
    private String uom;

    @ApiModelProperty(value = "整车定位")
    @SysCode(sys = "yst-supp", mod = "ITEM_POSIT")
    private String itemPosit;
    private String itemPositName;

    @ApiModelProperty(value = "渠道类型")
    @SysCode(sys = "yst-supp", mod = "CHANNEL_TYPE")
    private String channelType;
    private String channelTypeName;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户区域")
    @SysCode(sys = "yst-supp", mod = "REGION")
    private String region;
    private String regionName;

    @ApiModelProperty(value = "整车类型")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    private String itemType3Name;

    @ApiModelProperty(value = "生产基地")
    @SysCode(sys = "yst-supp", mod = "ORIGIN")
    private String origin;
    private String originName;

    @ApiModelProperty(value = "发货基地")
    private String desCode;

    @ApiModelProperty(value = "系列")
    private String itemGroup;

    @ApiModelProperty(value = "包装方式")
    @SysCode(sys = "yst-supp", mod = "PACK_DEMAND")
    private String packDemand;
    private String packDemandName;

    @ApiModelProperty(value = "次返")
    private BigDecimal everyRebate;

    @ApiModelProperty(value = "追加返利")
    private BigDecimal addRebate;

    @ApiModelProperty(value = "月返")
    private BigDecimal mounthRebate;

    @ApiModelProperty(value = "统筹")
    private BigDecimal overall;

    @ApiModelProperty(value = "追加统筹")
    private BigDecimal addOverall;

    @ApiModelProperty(value = "货币码")
    private String currCode;

    @ApiModelProperty(value = "货币名称")
    private String currName;

    @ApiModelProperty(value = "政策编号")
    private String policyNo;

    @ApiModelProperty(value = "是否处理车")
    private Boolean handleFlag;

    @ApiModelProperty(value = "电池配比（%）")
    private String batteryRatios;

    @ApiModelProperty(value = "有无月返")
    private Boolean mounthRebateFlag;

    @ApiModelProperty(value = "有无年返")
    private Boolean yearRebateFlag;

    @ApiModelProperty(value = "生效日期")
    private LocalDateTime effectiveDatetime;

    @ApiModelProperty(value = "失效日期")
    private LocalDateTime expiryDatetime;

    @ApiModelProperty(value = "价格状态")
    private String priceStatus;

    @ApiModelProperty(value = "总价")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "政策备注")
    private String policyRemark;

    @ApiModelProperty(value = "其他备注1")
    private String otherRemark1;

    @ApiModelProperty(value = "其他备注2")
    private String otherRemark2;
    private String elementPath;
    private String elementPathValue;

    @ApiModelProperty("门店加价率")
    private Map<String, BigDecimal> storeAddRateMap;
}
