package com.elitesland.yst.emdg.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/2/9
 */
@Data
@ApiModel("品类属性key返参")
public class ItmCatePropPagingDTO implements Serializable {

    private static final long serialVersionUID = -6384177935740268594L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "Id")
    private Long id;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String itemCateCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称")
    private String itemCateName;

    /**
     * 属性名编码
     */
    @ApiModelProperty(value = "属性名编码")
    private String catePropCode;

    /**
     * 属性名名称
     */
    @ApiModelProperty(value = "属性名名称")
    private String catePropName;

    /**
     * 属性类型 [UDC]ITM:CATE_PROP_TYPE
     */
    @ApiModelProperty(value = "属性类型 [UDC]ITM:CATE_PROP_TYPE")
    @SysCode(sys = "yst-supp", mod = "CATE_PROP_TYPE")
    private String catePropType;
    @ApiModelProperty("属性类型名称")
    private String catePropTypeName;

    /**
     * 单选复选(0:单选,1:复选)
     */
    @ApiModelProperty(value = "单选复选(0:单选,1:复选)")
    private Integer isBox;

    /**
     * 录入方式(0:列表选择,1:手动输入)
     */
    @ApiModelProperty(value = "录入方式(0:列表选择,1:手动输入)")
    private Integer isHand;

    /**
     * 是否必填(0:否,1:是)
     */
    @ApiModelProperty(value = "是否必填(0:否,1:是)")
    private Integer isMust;

    @ApiModelProperty(value = "自定义属性(0:否,1:是)")
    private Integer isCust;


    @ApiModelProperty(value = "用于检索(0:否,1:是)")
    private Integer isSearch;

    /**
     * 是否和SKU相关(0:否,1:是)
     */
    @ApiModelProperty(value = "是否和SKU相关(0:否,1:是)")
    private Integer isSku;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer sortNo;

    /**
     * 属性值
     */
    @ApiModelProperty(value = "属性值")
    private String valueNames;

    /**
     * 品类全路径
     */
//    @ApiModelProperty(value = "品类全路径")
//    private List<ItmItemCateSimpleTreeVO> itemCatePath;

}
