package com.elitesland.yst.emdg.support.provider.item.service;

import com.elitesland.yst.emdg.support.Application;
import com.elitesland.yst.emdg.support.provider.item.dto.EmdgItemCateRpcDTO;
import com.elitesland.yst.emdg.support.provider.item.param.EmdgItemCateRpcQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/01/03
 * @Version 1.0
 * @Content:
 */
@FeignClient(name = Application.NAME, path = EmdgItemCateRpcService.URI)
public interface EmdgItemCateRpcService {
    String URI = Application.URI_PREFIX + "/emdg/itemCate";

    /**
     * 查询品类基本信息列表
     * @param param 查询条件
     * @return dto
     */
    @PostMapping("/findItemCateCommon")
    List<EmdgItemCateRpcDTO> findItemCateCommon(@RequestBody EmdgItemCateRpcQueryDTO param);

    @PostMapping("/findFirstCommonRpc")
    EmdgItemCateRpcDTO findFirstCommonRpc(EmdgItemCateRpcQueryDTO queryVO);

    /**
     * 根据品系编码查询下级品类信息
     * @param param 查询条件
     * @return dto
     */
    @PostMapping("/findBySuperiors")
    List<EmdgItemCateRpcDTO> findBySuperiors(@RequestBody EmdgItemCateRpcQueryDTO param);

}
