package com.elitesland.yst.emdg.support.provider.item.service;

import com.elitesland.yst.emdg.support.Application;
import com.elitesland.yst.emdg.support.provider.item.dto.ItemScopeDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author Danny.Wang
 * @title ItemScopeRpcSerive
 * @Date2023/3/14 10:47
 */
@FeignClient(name = Application.NAME, path = Application.PATH + ItemScopeRpcSerive.PATH)
@Validated
public interface ItemScopeRpcSerive {
    String PATH = "/lm/itm/itemScope/rpc";

    /**
     * 根据商品编码查询商品销售范围
     * @param itemCodes 商品sku编码
     * @return
     */
        @PostMapping("/findItemScope")
    List<ItemScopeDTO> findItemScopeRpc(@RequestBody List<String> itemCodes);

}
