package com.elitesland.yst.emdg.support.provider.item.param;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/12/31
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgItemCommonRpcQueryDTO ", description = "商品公共基础查询RPC入参")
public class EmdgItemCommonRpcQueryDTO extends AbstractExportQueryParam implements Serializable {
    @Serial
    private static final long serialVersionUID = -2230161344389853646L;

    @ApiModelProperty(value = "商品编码或名称模糊查询")
    private String itemKeyword;

    /**
     * 商品SKU的ID集合
     */
    @ApiModelProperty("商品SKU的ID集合")
    private List<Long> itemIds;

    /**
     * 商品SKU的编码集合
     */
    @ApiModelProperty("商品SKU的编码集合")
    private List<String> itemCodes;

    /**
     * 商品SPU ID列表
     */
    @ApiModelProperty("商品SPU ID列表")
    private List<Long> spuIds;

    /**
     * 商品SPU编码列表
     */
    @ApiModelProperty("商品SPU编码列表")
    private List<String> spuCodes;


    @ApiModelProperty(value = "物料类型/商品分类 [UDC]yst-supp:ITEM_TYPE2")
    private String itemType2;
    @ApiModelProperty(value = "物料类型/商品分类 [UDC]yst-supp:ITEM_TYPE2")
    private List<String> itemType2List;
    @ApiModelProperty(value = "物料类型/车辆类型 [UDC]yst-supp:ITEM_TYPE5")
    private String itemType5;
    @ApiModelProperty(value = "物料类型/车辆类型 [UDC]yst-supp:ITEM_TYPE5")
    private List<String> itemType5List;

    @ApiModelProperty(value = "商品状态 [UDC]yst-supp:ITEM_STATUS")
    private List<String> itemStatus3List;

    @ApiModelProperty("商城上架状态 [UDC]yst-supp:UP_DOWN_STATUS")
    private List<String> es7List;

    @ApiModelProperty(value = "SPU商品状态 [UDC]yst-supp:ITEM_STATUS")
    private List<String> es9List;

    @ApiModelProperty("SPU维度的商城上架状态 [UDC]yst-supp:UP_DOWN_STATUS")
    private List<String> es8List;


    @ApiModelProperty(value = "组织ID")
    private Long buId;
    @ApiModelProperty(value = "组织编码")
    private String buCode;

}
