package com.elitesland.yst.emdg.support.provider.item.param;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/12/30
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgItemRpcQueryDTO ", description = "商品RPC入参")
public class EmdgItemRpcQueryDTO extends AbstractExportQueryParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -8918909467058647238L;

    @ApiModelProperty("主键ID")
    private Long id;
    @ApiModelProperty("主键ID集合")
    private List<Long> ids;

    @ApiModelProperty("销售组织")
    private List<String> buCodeListList;

    @ApiModelProperty(value = "一级品系")
    private List<String> itemCateCode2List;

    @ApiModelProperty(value = "品类编号/二级品类")
    private List<String> itemCateCodeList;

    @ApiModelProperty("商品SKU的编码集合")
    private List<String> itemCodes;
    @ApiModelProperty("过滤的商品SKU的编码集合")
    private List<String> itemCodesNot;

    @ApiModelProperty("商品SPU的ID集合")
    private List<Long> spuIds;

    @ApiModelProperty(value = "SPU编码")
    private String spuCode;
    @ApiModelProperty(value = "SPU编码集合")
    private List<String> spuCodeList;
    @ApiModelProperty(value = "过滤的SPU编码集合")
    private List<String> spuCodeListNot;
    @ApiModelProperty(value = "SPU编码模糊查询")
    private String spuCodeKeyword;

    @ApiModelProperty(value = "SPU编码或名称模糊查询")
    private String spuKeyword;

    @ApiModelProperty(value = "SPU名称模糊查询")
    private String spuNameKeyword;

    @ApiModelProperty(value = "物料类型/商品分类 [UDC]yst-supp:ITEM_TYPE2")
    private String itemType2;
    @ApiModelProperty(value = "物料类型/商品分类 [UDC]yst-supp:ITEM_TYPE2")
    private List<String> itemType2List;
    @ApiModelProperty(value = "物料类型/车辆类型 [UDC]yst-supp:ITEM_TYPE5")
    private String itemType5;
    @ApiModelProperty(value = "物料类型/车辆类型 [UDC]yst-supp:ITEM_TYPE5")
    private List<String> itemType5List;

    @ApiModelProperty(value = "商品状态 [UDC]yst-supp:ITEM_STATUS")
    private List<String> itemStatus3List;

    @ApiModelProperty("商城上架状态 [UDC]yst-supp:UP_DOWN_STATUS")
    private List<String> es7List;

    @ApiModelProperty("图片是否已维护 [UDC]yst-supp:MAINTENANCE_TYPE")
    private List<String> es6List;

    @ApiModelProperty(value = "产地/原产国/交货工厂 [UDC]yst-supp:ORIGIN")
    private List<String> originList;

    @ApiModelProperty(value = "SKU商品标签编码")
    private List<String> itemTagCodeList;

    @ApiModelProperty(value = "SPU商品状态 [UDC]yst-supp:ITEM_STATUS")
    private List<String> es9List;

    @ApiModelProperty("SPU维度的商城上架状态 [UDC]yst-supp:UP_DOWN_STATUS")
    private List<String> es8List;

    @ApiModelProperty("视频是否已维护 [UDC]yst-supp:MAINTENANCE_TYPE")
    private List<String> es10List;
}
