package com.elitesland.yst.emdg.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhengyue
 * @description: 三包配件收料方式DTO
 * @date 2023/11/28 10:39
 */
@Data
public class ItmReceivingCfgRpcDTO implements Serializable {

    private static final long serialVersionUID = 1643615437313344990L;

    @ApiModelProperty(name = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "配件类型(UDC:ITEM_TYPE3)")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    private String itemType3Name;

    @ApiModelProperty("收料方式(UDC:RECEIVING_TYPE)")
    @SysCode(sys = "yst-supp", mod = "RECEIVING_TYPE")
    private String receivingType;
    private String receivingTypeName;

    @ApiModelProperty("加价率")
    private BigDecimal addRate;

    @ApiModelProperty("备注")
    private String remark;

}
