package com.elitesland.yst.emdg.support.provider.item.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.emdg.support.Application;
import com.elitesland.yst.emdg.support.provider.item.dto.EmdgItemCommonRpcDTO;
import com.elitesland.yst.emdg.support.provider.item.dto.EmdgItemRpcPageDTO;
import com.elitesland.yst.emdg.support.provider.item.param.EmdgItemCommonRpcQueryDTO;
import com.elitesland.yst.emdg.support.provider.item.param.EmdgItemRpcQueryDTO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/12/30
 * @Version 1.0
 * @Content:
 */
@FeignClient(name = Application.NAME, path = EmdgItemRpcService.URI)
public interface EmdgItemRpcService {

    String URI = Application.URI_PREFIX + "/emdg/item";

    @PostMapping("/searchEmdgItem")
    PagingVO<EmdgItemRpcPageDTO> searchEmdgItem(@RequestBody EmdgItemRpcQueryDTO param);

    @PostMapping("/selectAuthRangeSpuItem")
    List<EmdgItemRpcPageDTO> selectAuthRangeSpuItem(@RequestBody EmdgItemRpcQueryDTO param);

    /**
     * 查询商品基本信息列表
     * @param param 查询条件
     * @return dto
     */
    @PostMapping("/findItemCommon")
    List<EmdgItemCommonRpcDTO> findItemCommon(@RequestBody EmdgItemCommonRpcQueryDTO param);
    /**
     * 查询商品基本信息列表
     * @param param 查询条件
     * @return dto
     */
    @PostMapping("/findItemCommonBase")
    List<EmdgItemCommonRpcDTO> findItemCommonBase(@RequestBody EmdgItemCommonRpcQueryDTO param);
}
