package com.elitesland.yst.template.rpc.param;

import com.elitesland.yst.template.constant.DemoCategoryEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * demo相关信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/1
 */
@Data
@Accessors(chain = true)
public class YstDemoDTO implements Serializable {
    private static final long serialVersionUID = -356206361738410377L;

    /**
     * ID
     */
    private Long id;

    /**
     * 编码
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 加入时间
     */
    private LocalDateTime joinTime;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 等级
     */
    private Integer gradle;

    /**
     * 分类
     */
    private DemoCategoryEnum category;

    /**
     * 余额
     */
    private BigDecimal balance;
}
