package com.huaihaigroup.dmp.inv;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.huaihaigroup.dmp.inv.dto.HhInvIdoRpcDtoParam;
import com.huaihaigroup.dmp.util.HhApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Validated
@FeignClient(name = HhApplication.NAME, path = HhApplication.PATH + HhInvDoRpcService.PATH)
public interface HhInvDoRpcService {
    String PATH = "/HhInvDo";

    /**
     * 生成入库单
     *
     * @param param
     * @return
     */
    @PostMapping("/generateInvIdo")
    ApiResult<Long> generateInvIdo(@RequestBody HhInvIdoRpcDtoParam param);

    /**
     * 生成出库单
     *
     * @param param
     * @return
     */
    @PostMapping("/generateInvOdo")
    ApiResult<Long> generateInvOdo(@RequestBody HhInvIdoRpcDtoParam param);

}
