package com.huaihaigroup.dmp.inv;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.huaihaigroup.dmp.inv.dto.HhInvWhAreaRpcDto;
import com.huaihaigroup.dmp.inv.dto.HhInvWhRpcDtoParam;
import com.huaihaigroup.dmp.inv.dto.HhInvWhUpdateStatusRpcParam;
import com.huaihaigroup.dmp.util.HhApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Validated
@FeignClient(name = HhApplication.NAME, path = HhApplication.PATH + HhInvWhRpcService.PATH)
public interface HhInvWhRpcService {
    String PATH = "/HhInvWh";

    @PostMapping("/findWhAreaByParam")
    List<HhInvWhAreaRpcDto> findWhAndWhAreaByParam(@RequestBody HhInvWhRpcDtoParam param);

    // 启用门店仓库
    @PostMapping("/activeWhByStore")
    ApiResult<?> activeWhByStore(@RequestBody HhInvWhUpdateStatusRpcParam param);

    // 禁用门店仓库
    @PostMapping("/inactiveWhByStore")
    ApiResult<?> inactiveWhByStore(@RequestBody HhInvWhUpdateStatusRpcParam param);
}
