package com.huaihaigroup.dmp.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


@Data
@ApiModel(value = "HhInvWhRpcDtoParam", description = "仓库及库区查询条件")
public class HhInvWhRpcDtoParam implements Serializable {

    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司ID集合")
    private List<Long> ouIds;

    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("仓库ID集合")
    private List<Long> whIds;

    @ApiModelProperty("功能区集合")
    private List<String> deter2s;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("仓库编码集合")
    private List<String> whCodes;

    @ApiModelProperty("发运地ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("发运地ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> desIds;

    @ApiModelProperty("功能区类型批量查询")
    private List<String> deter2Types;

    @ApiModelProperty("外部仓库编号")
    private String otherWhCode;

    @ApiModelProperty("外部仓库编码集合")
    private List<String> otherWhCodes;

    @ApiModelProperty("经销商编码")
    private String dealerCode;
}
