package com.huaihaigroup.dmp.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


@Data
@ApiModel(value = "HhInvWhAreaRpcDto ", description = "仓库和功能区数据返回")
public class HhInvWhAreaRpcDto implements Serializable {

    @ApiModelProperty("唯一编号功能区ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long deter2Id;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("外部仓库编号")
    private String otherWhCode;

    @ApiModelProperty("是否生成库存账")
    private Boolean generateInvAcc;

    @ApiModelProperty("经销商编码")
    private String dealerCode;

    @ApiModelProperty("销售组织编码")
    private Object desCodeJson;

    @ApiModelProperty("销售组织编码集合")
    private List<String> desCodeList;

}
