package com.huaihaigroup.dmp.order.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;


@Data
@ApiModel(value = "HhSalSoRpcParam")
public class HhSalSoRpcParam implements Serializable {

    @ApiModelProperty("销售公司编码")
    private String ouCode;
    @ApiModelProperty("销售公司id")
    private Long ouId;

    @ApiModelProperty(value = "年")
    private String year;
    @ApiModelProperty(value = "经销商code")
    private String dealerCode;
    @ApiModelProperty(value = "销售部门")
    private String saleDepartment;
    @ApiModelProperty(value = "大区")
    private String deter3;
    @ApiModelProperty(value = "大区经理")
    private String deter4;
    @ApiModelProperty(value = "营销经理")
    private String deter2;
    @ApiModelProperty(value = "10 整车 20 配件 40 广宣品")
    private String docType3;


    @ApiModelProperty(value = "开始")
    private LocalDateTime startTime;
    @ApiModelProperty(value = "结束")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "状态列表")
    private List<String> docStatusList;


    @ApiModelProperty(value = "订单类型")
    private String docCls;

    @ApiModelProperty(value = "品类相关")
    private List<HhCateCodeParam> deteil;
}
