package com.huaihaigroup.dmp.order.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


@Data
@ApiModel(value = "HhSalDoRpcResp")
public class HhSalDoRpcResp implements Serializable {

    @ApiModelProperty(value = "发货单号")
    private String docNo;

    @ApiModelProperty(value = "发货单行号")
    private BigDecimal lineNo;

    @ApiModelProperty(value = "发货日期")
    private LocalDateTime shipDateTime;

    @ApiModelProperty(value = "订单类型")
    private String relateDocCls;

    @ApiModelProperty(value = "订单编号")
    private String relateDocNo;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "规格型号")
    private String itemSpec;

    @ApiModelProperty(value = "成交价")
    private BigDecimal transactionPrice;

    @ApiModelProperty(value = "签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty(value = "签收金额")
    private BigDecimal confirmAmt;
}
