package com.huaihaigroup.dmp.sale.dto;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "HhStoreRpcParam", description = "RPC查询门店入参")
public class HhStoreRpcDto implements Serializable {

    @ApiModelProperty(value = "门店id")
    private Long id;
    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty(value = "门店名称")
    private String storeName;
    /**
     * 是否形象店 1：否 2：是
     */
    @ApiModelProperty(value = "是否形象店 1：否 2：是")
    private String image;

    /**
     * 部门id
     */
    @ApiModelProperty(value = "部门id")
    private Long deptId;


    /**
     * 部门编码
     */
    @ApiModelProperty(value = "部门编码")
    private String deptCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称")
    private String deptName;


    /**
     * 业务员员工ID
     */
    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;
    @ApiModelProperty("业务员名称")
    private String agentName;
    @ApiModelProperty("业务员编码")
    private String agentCode ;

    @ApiModelProperty(value = "销售大区")
    private String saleRegion;


    @ApiModelProperty(value = "门店性质")
    private String storeProp;
    @ApiModelProperty(value = "门店负责人")
    private String storeManager;
    /**
     * 门店状态
     */
    @ApiModelProperty(value = "门店状态 UDC:yst-sale:STORE_STATUS")
    private String storeStatus;


    /**
     * 服务性质
     */
    @ApiModelProperty(value = "服务性质")
    private String serviceNature;

    @ApiModelProperty(value = "经销商编码")
    private String dealerCode;

    @ApiModelProperty(value = "经销商名称")
    private String dealerName;

    @ApiModelProperty(value = "装修预算费用")
    private BigDecimal decorationCost;
    @ApiModelProperty(value = "申请报销费用")
    private BigDecimal reimbursementCost;
    @ApiModelProperty(value = "店面等级")
    private String storeClass;

    @ApiModelProperty(value = "经营品类")
    private String operCategory;
}
