package com.huaihaigroup.dmp.inv;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.huaihaigroup.dmp.inv.dto.HhInvIdoRpcDtoParam;
import com.huaihaigroup.dmp.inv.dto.HhInvIdoRpcSearchParam;
import com.huaihaigroup.dmp.inv.dto.InvIdoRpcRespVO;
import com.huaihaigroup.dmp.util.HhApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Validated
@FeignClient(name = HhApplication.NAME, path = HhApplication.PATH + HhInvDoRpcService.PATH)
public interface HhInvDoRpcService {
    String PATH = "/HhInvDo";

    /**
     * 生成入库单
     *
     * @param param
     * @return
     */
    @PostMapping("/generateInvIdo")
    ApiResult<Long> generateInvIdo(@RequestBody HhInvIdoRpcDtoParam param);

    /**
     * 生成出库单
     *
     * @param param
     * @return
     */
    @PostMapping("/generateInvOdo")
    ApiResult<Long> generateInvOdo(@RequestBody HhInvIdoRpcDtoParam param);


    /**
     * 根据来源单据号和来源类型查询入库单
     *
     * @param param
     * @return
     */
    @PostMapping("/findByRelateDocNo")
    ApiResult<List<InvIdoRpcRespVO>> findByRelateDocNo(@RequestBody HhInvIdoRpcSearchParam param);
}
