package com.huaihaigroup.dmp.inv.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


@Data
@ApiModel(value = "HhInvTrnRpcDtoResp", description = "RPC调拨单返回数据")
public class HhInvTrnRpcDtoResp implements Serializable {

    @ApiModelProperty("来源单ID")
    private Long sourceDocId;

    @ApiModelProperty("来源单据类型")
    private String sourceDocType;

    @ApiModelProperty("来源单据号")
    private String sourceDocNo;

    @ApiModelProperty("调拨原因 [UDC]INV:TRN_REASON")
    private String reasonCode;

    @ApiModelProperty("调拨类别编码 [UDC]INV:TRN_TYPE")
    private String docType;

    @ApiModelProperty("发货方经销商编码")
    private String outDealerCode;
    @ApiModelProperty("发货方经销商名称")
    private String outDealerName;
    @ApiModelProperty("发货方仓库编码")
    private String outWhCode;
    @ApiModelProperty("发货方仓库功能区编码")
    private String outDeter2;


    @ApiModelProperty("收货方经销商编码")
    private String inDealerCode;
    @ApiModelProperty("收货方经销商名称")
    private String inDealerName;
    @ApiModelProperty("收货方仓库编码")
    private String inWhCode;
    @ApiModelProperty("收货方仓库功能区编码")
    private String inDeter2;

    @ApiModelProperty("配送方式编码")
    private String allocType;

//    @ApiModelProperty("商品明细")
//    private List<HhInvTrnDetailRpcResp> details;
}
