package com.huaihaigroup.dmp.order.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.huaihaigroup.dmp.order.Application;
import com.huaihaigroup.dmp.order.param.HhSalSoRpcParam;
import com.huaihaigroup.dmp.order.resp.HhSalSoRpcResp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + HhSalSoRpcService.PATH)
public interface HhSalSoRpcService {
    String PATH = "/hhSalSo";

    /**
     * 合同达成率报表-查询订单数据
     *
     * @param param
     * @return
     */
    @PostMapping("/saleContractRateReport")
    ApiResult<List<HhSalSoRpcResp>> saleContractRateReport(@RequestBody HhSalSoRpcParam param);

}
