package com.huaihaigroup.dmp.inv.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


@Data
@ApiModel(value = "HhInvIdoRpcDtoParam")
public class HhInvIdoRpcDtoParam implements Serializable {

    @ApiModelProperty("来源单ID")
    private Long sourceDocId;

    @ApiModelProperty("来源单据号")
    private String sourceDocNo;

    @ApiModelProperty("来源单据类型")
    private String sourceDocType;

    @ApiModelProperty("经销商编码")
    private String dealerCode;

    @ApiModelProperty("经销商名称")
    private String dealerName;

    @ApiModelProperty("仓库id")
    @NotNull
    private Long whId;

    @ApiModelProperty("仓库编码")
    @NotNull
    private String whCode;

    @ApiModelProperty("仓库功能区编码")
    @NotNull
    private String deter2;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("商品明细")
    private List<HhInvIdoItemRpcDtoParam> details;
}
