package com.huaihaigroup.dmp.fin.flow;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.huaihaigroup.dmp.fin.Application;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:账户流水
 * </p>
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + AccountFlowRpcService.PATH)
public interface AccountFlowRpcService {

    String PATH = "/accountFlow";

    /**
     * 账户流水保存
     *
     * @param rpcParams 入参
     * @return 流水号
     */
    @PostMapping("/save")
    ApiResult<AccountFlowRpcDTO> save(@RequestBody List<AccountFlowRpcParam> rpcParams);

    /**
     * 账户流水保存
     *
     * @param rpcParams 入参
     * @return 流水号
     */
    @PostMapping("/generateAccountFlow")
    ApiResult<Boolean> generateAccountFlow(@RequestBody AccountFlowRpcParam rpcParams);

    /**
     * 校验账户余额
     */
    @PostMapping("/checkAccountBalance")
    ApiResult<Boolean> checkAccountBalance(@RequestBody AccountFlowRpcParam rpcParams);
}
