package com.huaihaigroup.dmp.inv;


import com.huaihaigroup.dmp.inv.dto.HhInvStkRpcResp;
import com.huaihaigroup.dmp.inv.dto.HhInvStkSapRpcParam;
import com.huaihaigroup.dmp.util.HhApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Validated
@FeignClient(name = HhApplication.NAME, path = HhApplication.PATH + HhInvStkRpcService.PATH)
public interface HhInvStkRpcService {
    String PATH = "/HhInvStk";

    @PostMapping("/findSapStkByParam")
    List<HhInvStkRpcResp> findSapStkByParam(@RequestBody HhInvStkSapRpcParam param);


    @PostMapping("/findInvAvalStk")
    Map<String, BigDecimal> findInvAvalStk(@RequestParam(value = "whCode") String whCode,
                                           @RequestParam(value = "itemId") Long itemId,
                                           @RequestParam(value = "uom") String uom);

    @PostMapping("/checkInvStkByVin")
    Boolean checkInvStkByVin(@RequestParam(value = "whCode") String whCode,
                             @RequestParam(value = "deter2") String deter2,
                             @RequestParam(value = "itemId") Long itemId,
                             @RequestParam(value = "vinNo") String vinNo);


}
