package com.huaihaigroup.dmp.fin.flow;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:账户流水
 * </p>
 */
@Data
public class AccountFlowRpcParam extends CustomFieldBaseModelVo implements Serializable {

    @ApiModelProperty("经销商编码")
    private String custCode;

    @ApiModelProperty("销售组织编码")
    private String buCode;

    @ApiModelProperty("商品类型")
    private String itemType;

    @ApiModelProperty("账户类型")
    private String accountType;

    @ApiModelProperty("数据来源")
    private String dataSource;

    @ApiModelProperty("交易类型")
    private String transactionType;

    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;

    @ApiModelProperty("来源平台")
    private String sourcePlatform;

    @ApiModelProperty("来源单据")
    private String sourceDoc;

    @ApiModelProperty("来源单据类型")
    private String sourceDocType;

    @ApiModelProperty("来源单据状态")
    private String sourceDocStatus;

    @ApiModelProperty("来源单据金额")
    private BigDecimal sourceDocAmount;

    @ApiModelProperty("来源单据门店编码")
    private String sourceDocStoreCode;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单据id")
    private Long sourceId;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("公司编码")
    private String companyCode;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("账户金额")
    private BigDecimal accountAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUserName;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("工作流实例id")
    private String workflowProcInstId;
}
