package com.huaihaigroup.dmp.order.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.huaihaigroup.dmp.order.Application;
import com.huaihaigroup.dmp.order.param.HhSalDoRpcParam;
import com.huaihaigroup.dmp.order.resp.HhSalDoRpcResp;
import com.huaihaigroup.dmp.order.resp.HhSalDoSapRpcResp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + HhSalDoRpcService.PATH)
public interface HhSalDoRpcService {
    String PATH = "/hhSalDo";

    /**
     * 对账查询发货单信息
     *
     * @param param
     * @return
     */
    @PostMapping("/reconcSalDo")
    ApiResult<List<HhSalDoRpcResp>> reconcSalDo(@RequestBody HhSalDoRpcParam param);

    /**
     * 对账查询发货单信息
     *
     * @param param
     * @return
     */
    @PostMapping("/sapNoList")
    ApiResult<List<HhSalDoSapRpcResp>> sapNoList(@RequestBody List<String> vinList);
}
