package com.huaihaigroup.dmp.fin.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.huaihaigroup.dmp.fin.Application;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Validated
@FeignClient(name = Application.NAME, path = HhAccountRpcService.URI)
public interface HhAccountRpcService {
    String URI = Application.URI_PREFIX + "/hhAccount";


    /**
     * 查询储值账户信息
     *
     * @param accountExtRpcParam
     * @return
     */
    @PostMapping("findAccByParam")
    ApiResult<HhAccountRpcVO> findAccByParam(@RequestBody HhAccountRpcParam accountExtRpcParam);


}
