package com.huaihaigroup.dmp.inv.dto;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "InvOdoRespVO", description = "库存出库单")
public class InvIdoRpcRespVO extends CustomFieldBaseModelVo implements Serializable {

    @ApiModelProperty("经销商编码")
    private String relateOuCode;

    @ApiModelProperty("经销商名称")
    private String relateOuName;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("单据状态 [UDC]yst-inv:IDO_STATUS")
    @SysCode(sys = "yst-inv", mod = "IDO_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    @ApiModelProperty("来源单据编号")
    private String relateDocNo;

    @ApiModelProperty("来源单据类别 [UDC]yst-supp:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    private String relateDocClsName;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名")
    private String whName;

    @ApiModelProperty("仓库类型")
    private String whType;

    @ApiModelProperty("仓库类型名")
    private String whTypeName;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("功能区名")
    private String deter2Name;

    @ApiModelProperty("单据日期")
    private LocalDateTime docDate;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("明细数量")
    private Long detailCount;

    @ApiModelProperty("入库时间")
    private LocalDateTime confirmTime;

}
