package com.huaihaigroup.dmp.order.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


@Data
@ApiModel(value = "HhSalDoRpcResp")
public class HhSalDoRpcResp implements Serializable {

    @ApiModelProperty(value = "发货单号")
    private String docNo;

    @ApiModelProperty(value = "发货单行号")
    private BigDecimal lineNo;

    @ApiModelProperty(value = "发货日期")
    private LocalDateTime shipDateTime;

    @ApiModelProperty(value = "订单类型")
    private String relateDocCls;

    @ApiModelProperty(value = "订单编号")
    private String relateDocNo;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "规格型号")
    private String itemSpec;

    @ApiModelProperty(value = "成交价")
    private BigDecimal transactionPrice;

    @ApiModelProperty(value = "签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty(value = "签收金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty(value = "经销商编码")
    private String custCode;

    @ApiModelProperty(value = "经销商名称")
    private String custName;

    @ApiModelProperty("是否直发二网 0：否 1：是")
    private String sendDirTwoCustFlag;

    @ApiModelProperty("收货方经销商编号")
    private String recvCustCode;

    @ApiModelProperty("收货方经销商名称")
    private String recvCustName;

    @ApiModelProperty("收货仓库id")
    private Long whId;

    @ApiModelProperty("收货仓库编码")
    private String whCode;

    @ApiModelProperty("功能库区编码")
    private String whLoc;

    /**
     * 销售组织id
     */
    @ApiModelProperty("销售组织id")
    private Long buId;
    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String buCode;
    /**
     * 销售组织name
     */
    @ApiModelProperty("销售组织name")
    private String buName;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

}
