/*
 * Decompiled with CFR 0.152.
 */
package com.tll.housekeeper.rpc.utils.bean;

import com.tll.housekeeper.rpc.utils.bean.BeanCopyUtilCallBack;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BeanUtils
extends org.springframework.beans.BeanUtils {
    private static final int BEAN_METHOD_PROP_INDEX = 3;
    private static final Pattern GET_PATTERN = Pattern.compile("get(\\p{javaUpperCase}\\w*)");
    private static final Pattern SET_PATTERN = Pattern.compile("set(\\p{javaUpperCase}\\w*)");

    public static void copyBeanProp(Object dest, Object src) {
        try {
            BeanUtils.copyProperties((Object)src, (Object)dest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Method> getSetterMethods(Object obj) {
        Method[] methods;
        ArrayList<Method> setterMethods = new ArrayList<Method>();
        for (Method method : methods = obj.getClass().getMethods()) {
            Matcher m = SET_PATTERN.matcher(method.getName());
            if (!m.matches() || method.getParameterTypes().length != 1) continue;
            setterMethods.add(method);
        }
        return setterMethods;
    }

    public static List<Method> getGetterMethods(Object obj) {
        Method[] methods;
        ArrayList<Method> getterMethods = new ArrayList<Method>();
        for (Method method : methods = obj.getClass().getMethods()) {
            Matcher m = GET_PATTERN.matcher(method.getName());
            if (!m.matches() || method.getParameterTypes().length != 0) continue;
            getterMethods.add(method);
        }
        return getterMethods;
    }

    public static <S, T> List<T> copyListProperties(List<S> sources, Supplier<T> target) {
        return BeanUtils.copyListProperties(sources, target, null);
    }

    public static <S, T> List<T> copyListProperties(List<S> sources, Supplier<T> target, BeanCopyUtilCallBack<S, T> callBack) {
        ArrayList<T> list = new ArrayList<T>(sources.size());
        for (S source : sources) {
            T t = target.get();
            BeanUtils.copyProperties(source, t);
            list.add(t);
            if (callBack == null) continue;
            callBack.callBack(source, t);
        }
        return list;
    }

    public static boolean isMethodPropEquals(String m1, String m2) {
        return m1.substring(3).equals(m2.substring(3));
    }

    public static Map<String, String> convertToMapIgnoreNull(Object object) {
        HashMap<String, String> map = new HashMap<String, String>();
        Class<?> clazz = object.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (field.get(object) == null) continue;
                map.put(field.getName(), field.get(object).toString());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("\u53c2\u6570\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return map;
    }
}

