package com.tll.housekeeper.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.housekeeper.Application;
import com.tll.housekeeper.rpc.dto.MessageCenterBearRpcDTO;
import com.tll.housekeeper.rpc.vo.UnifiedReturnRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 消息中心.
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@FeignClient(name = Application.NAME, path = MessageCenterRpcService.URI)
@Validated
public interface MessageCenterRpcService {
    String URI = Application.URI_PREFIX + "/api/messageCenter";
    

    /**
     * 推送消息 新增消息数据  (已变更)
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "推送消息")
    @PostMapping(value = "/messageCenterAdd")
    ApiResult<UnifiedReturnRpcVO> messageCenterAdd(@RequestBody MessageCenterBearRpcDTO dto);

    @ApiOperation(value = "甜学院-批量推送消息")
    @PostMapping(value = "/batchMessageSa")
    ApiResult<UnifiedReturnRpcVO> batchMessageSa(@RequestBody @Validated MessageCenterBearRpcDTO dto);
}
