package com.tll.housekeeper.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.housekeeper.Application;
import com.tll.housekeeper.rpc.dto.PopupBearRpcDTO;
import com.tll.housekeeper.rpc.dto.PopupRecycleRpcDTO;
import com.tll.housekeeper.rpc.vo.PopupRecycleRpcVO;
import com.tll.housekeeper.rpc.vo.UnifiedReturnRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 弹窗中心.
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@FeignClient(name = Application.NAME, path = PopupRpcService.URI)
@Validated
public interface PopupRpcService {
    String URI = Application.URI_PREFIX + "/api/popup";


    /**
     * 推送弹窗
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "推送弹窗")
    @PostMapping(value = "/popupAdd")
    ApiResult<UnifiedReturnRpcVO> popupAdd(@RequestBody PopupBearRpcDTO dto);


    @ApiOperation(value = "弹窗回收")
    @PostMapping(value = "/popupRecycle")
    ApiResult<PopupRecycleRpcVO> popupRecycle(@RequestBody PopupRecycleRpcDTO dto);

}
