package com.tll.housekeeper.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.housekeeper.Application;
import com.tll.housekeeper.rpc.dto.PopupBearRpcDTO;
import com.tll.housekeeper.rpc.dto.PushMessageRpcDTO;
import com.tll.housekeeper.rpc.vo.UnifiedReturnRpcVO;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 弹窗中心.
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@FeignClient(name = Application.NAME, path = PushRpcService.URI)
@Validated
public interface PushRpcService {
    String URI = Application.URI_PREFIX + "/api/publicPush";


    @ApiOperation(value = "公共推送服务")
    @PostMapping(value = "/host")
    ApiResult<UnifiedReturnRpcVO> host(@RequestBody List<PushMessageRpcDTO> dto);

}
