package com.tll.housekeeper.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.housekeeper.Application;
import com.tll.housekeeper.rpc.dto.BreachRefundSubmitRpcDTO;
import com.tll.housekeeper.rpc.dto.WorkFlowBatchRpcDTO;
import com.tll.housekeeper.rpc.dto.WorkFlowRpcDTO;
import com.tll.housekeeper.rpc.vo.BreachRefundSubmitRpcVO;
import com.tll.housekeeper.rpc.vo.WorkFlowRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author XieBeiChen
 * @date 2025-08-07 14:09
 * @description
 */
@FeignClient(name = Application.NAME, path = WorkFlowRpcService.URI)
@Validated
public interface WorkFlowRpcService {

    String URI = Application.URI_PREFIX + "/api/workflow";


    @ApiOperation(value = "工作流查询")
    @PostMapping(value = "/findOne")
    ApiResult<WorkFlowRpcVO> findOne(@RequestBody WorkFlowRpcDTO dto);

    @ApiOperation(value = "工作流批量查询")
    @PostMapping(value = "/list")
    ApiResult<List<WorkFlowRpcVO>> list(@RequestBody WorkFlowBatchRpcDTO dto);

    @ApiOperation(value = "违约金返还审核提交")
    @PostMapping(value = "/breachRefundSubmit")
    ApiResult<BreachRefundSubmitRpcVO> breachRefundSubmit(@RequestBody BreachRefundSubmitRpcDTO dto);


}
