package com.tll.housekeeper.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 发起审核数据
 *
 * @author Jxinx
 * @since 2025-05-08
 */
@Data
@ApiModel(description = "违约金返还审核")
public class  BreachRefundSubmitRpcDTO implements Serializable {


    @NotNull(message = "发起审核类型不能为空")
    @ApiModelProperty(value = "发起审核类型：1-甜掌柜收银账户线上开户申请，2-巡检行程变更申请,3-违约金返还审核流程")
    private Integer submitType;

    @ApiModelProperty(value = "门店编码（发起审核类型为1时传参)")
    private String storeCode;

    @ApiModelProperty("违约金返还审核流程实体信息")
    private BreachRefundRpcDTO breachRefund;
}
