package com.tll.housekeeper.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 消息中心记录.
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "消息中心记录")
public class MessageCenterRpcDTO implements Serializable {

    @ApiModelProperty("消息中心唯一标识")
    private String messageUnique;

    @ApiModelProperty("任务类型 1:门店任务 2:员工任务")
    private String taskType;

    @ApiModelProperty("任务形式 1:任务型 2:通知型 3:收集型")
    private String taskForm;

    @ApiModelProperty("主任务id")
    private String taskId;

    @ApiModelProperty("子任务id")
    private String subtaskId;

    @ApiModelProperty("消息类型")
    private String messageType;

    @ApiModelProperty("来源")
    private String source;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("落地页")
    private String landingPage;
    
    @ApiModelProperty("类型: 0:单个任务 1:今日待办 2:催办 3:提醒 4:版本更新")
    private String type;

    @ApiModelProperty("跳转标识: 0:子任务详情 1:主任务详情 2:主任务列表")
    private String skip;

    @ApiModelProperty("关联人员")
    private List<MessageCenterUserRpcDTO> userList;
    
}
