package com.tll.housekeeper.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 消息中心记录.
 *
 * @author Kaiser（qishendeng）
 * @date 2025/03/13
 */
@Data
@ApiModel(description = "消息中心记录")
public class MessageCenterSARpcDTO implements Serializable {

    @ApiModelProperty("消息类型：系统消息 待办通知 任务消息(非必传默认系统消息)")
    private String messageType;

    @ApiModelProperty("标题")
    @NotBlank(message = "标题不能为null")
    private String title;

    @ApiModelProperty("描述(副标题)")
    @NotBlank(message = "描述不能为null")
    private String description;

    @ApiModelProperty("落地页(页面跳转url-甜学院)")
    @NotBlank(message = "落地页不能为null")
    private String landingPage;

    @ApiModelProperty("跳转标识: 0:子任务详情 1:主任务详情 2:主任务列表 3:甜学院")
    private String skip;

    @ApiModelProperty("甜管家-关联人员")
    private List<MessageCenterUserSARpcDTO> userList;

    @ApiModelProperty("甜掌柜-关联人员")
    private List<MessageCenterUserSASweetRpcDTO> sweetUserList;
    
}
