package com.tll.housekeeper.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 弹窗记录.
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "弹窗记录")
public class PopupRpcDTO implements Serializable {

    @ApiModelProperty("弹窗唯一标识")
    private String popupUnique;
    
    @ApiModelProperty("任务类型 1:门店任务 2:员工任务")
    private String taskType;

    @ApiModelProperty("任务形式 1:任务型 2:通知型 3:收集型")
    private String taskForm;

    @ApiModelProperty("主任务id")
    private String taskId;

    @ApiModelProperty("子任务id")
    private String subtaskId;

    @ApiModelProperty("使用场景")
    private String usageScenarios;

    @ApiModelProperty("来源")
    private String source;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("弹窗是否可关闭 1:是 2:否")
    private String popupStyle;

    @ApiModelProperty("落地页")
    private String landingPage;

    @ApiModelProperty("跳转标识: 0:子任务详情 1:主任务列表 2:主任务详情")
    private String skip;

    @ApiModelProperty("类型: 0:单个任务 1:今日待办 2:催办 3:提醒 4:版本更新")
    private String type;

    @ApiModelProperty("关联人员")
    private List<PopupUserRpcDTO> userList;
    
}
