package com.tll.housekeeper.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 推送消息.
 *
 * @author Kaiser（qishendeng）
 * @date 2025/5/19
 */
@Data
@ApiModel(description = "推送消息")
public class PushMessageRpcDTO implements Serializable {

    @ApiModelProperty("消息类型：系统消息 待办通知 任务消息(非必传默认系统消息)")
    private String messageType;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("描述(副标题)")
    private String description;

    @ApiModelProperty("落地页")
    private String landingPage;

    @ApiModelProperty("跳转标识: 0:子任务详情 1:主任务详情 2:主任务列表 3:甜学院 4:内部路径(必须是完整路径)")
    private String skip;

    @ApiModelProperty("来源")
    private String source;

    @ApiModelProperty("类型: 0:单个任务 1:今日待办 2:催办 3:提醒 4:版本更新 5:甜学院 6:内部路径(必须是完整路径)")
    private String type;

    @ApiModelProperty("弹窗使用场景")
    private String usageScenarios;

    @ApiModelProperty("弹窗是否可关闭 1:是 2:否")
    private String popupStyle;

    @ApiModelProperty("1:消息中心 2:极光 3:弹窗")
    private List<String> function;

    @ApiModelProperty("关联人员")
    private List<PushMessageUserDTO> userList;

    @Data
    @ApiModel(description = "消息中心记录用户关联表")
    public static class PushMessageUserDTO implements Serializable {

        @ApiModelProperty("业务中台-用户id")
        private Long userId;

    }

}
