package com.tll.housekeeper.rpc.param.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Lob;
import java.io.Serializable;

/**
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
public class EmployeeAnnouncementsDetailVO implements Serializable {

    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "公告名称")
    private String name;

    @ApiModelProperty(value = "公告所属部门名称")
    private String departmentName;

    @ApiModelProperty(value = "公告所属部门编码")
    private String departmentCode;

    @ApiModelProperty("是否使用公告操作 0：无操作 1：1个按钮 2：两个按钮")
    private Integer actionType;

    @ApiModelProperty("按钮文字1")
    private String actionButton;

    @ApiModelProperty("按钮文字2")
    private String actionButtonTwo;

    @ApiModelProperty("点击按钮名称")
    private String clickButtonName;

    @Lob
    @ApiModelProperty(value = "公告内容")
    private String content;

    @ApiModelProperty(value = "查阅状态: 0:未读 2:已读")
    private Integer isRead;
}
