package com.tll.housekeeper.rpc.param.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 员工任务管理 详情
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(description = "员工任务管理详情")
public class EmployeeTasksDetailsVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    /**
     * 记录创建时间
     */
    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    /**
     * 任务Id
     */
    @ApiModelProperty(value = "任务Id")
    private String taskId;

    /**
     * 任务名称
     */
    @ApiModelProperty(value = "任务名称")
    private String taskName;

    /**
     * 任务备注
     */
    @ApiModelProperty(value = "任务备注")
    private String taskRemark;

    /**
     * 任务形式
     */
    @ApiModelProperty(value = "任务形式 1:任务型 2:通知型 3:收集型")
    private String taskForm;

    /**
     * 任务内容
     */
    @ApiModelProperty(value = "任务内容 1:指定表单 2:指定公告")
    private String taskNote;

    @ApiModelProperty(value = "表单或公告名称")
    private String titleName;

    /**
     * 催办时间
     */
    @ApiModelProperty(value = "催办时间")
    private LocalDateTime urgeTime;

    /**
     * 描述 (催办说明)
     */
    @ApiModelProperty(value = "描述 (催办说明)")
    private String actionDescribe;

    /**
     * 是否撤销 0：未撤销 1：已撤销
     */
    @ApiModelProperty(value = "是否撤销 0：未撤销 1：已撤销")
    private Integer isBack;

    /**
     * 是否催办  0：未催办  1:已催办
     */
    @ApiModelProperty(value = "是否催办  0：未催办  1:已催办")
    private Integer isUrge;

    /**
     * 查阅状态  0：未查阅  1：已查阅
     */
    @ApiModelProperty(value = "查阅状态  0：未查阅  1：已查阅")
    private Integer isRead;

    /**
     * 任务计划开始时间
     */
    @ApiModelProperty(value = "任务计划开始时间")
    private LocalDateTime taskPlanStartTime;

    /**
     * 任务计划结束时间
     */
    @ApiModelProperty(value = "任务计划结束时间")
    private LocalDateTime taskPlanEndTime;

    /**
     * 任务状态  0：待提交   1：已完成   2：已回收  3：已过期  4：整改中 5：待整改 6：已失效
     */
    @ApiModelProperty(value = "任务状态  0：待提交   1：已完成   2：已回收  3：已过期  4：整改中 5：待整改 6：已失效")
    private Integer taskState;

    /**
     * 任务创建人
     */
    @ApiModelProperty(value = "任务创建人")
    private String createBy;

    /**
     * 计划执行人
     */
    @ApiModelProperty(value = "计划执行人")
    private String planExecutor;

    /**
     * 实际执行人
     */
    @ApiModelProperty(value = "实际执行人")
    private String realExecutor;

    /**
     * 实际执行人角色
     */
    @ApiModelProperty(value = "实际执行人角色")
    private String realExecutorRole;

    /**
     * 任务所属部门id
     */
    @ApiModelProperty(value = "任务所属部门id")
    private String taskDepartment;

    /**
     * 任务所属部门名称
     */
    @ApiModelProperty(value = "任务所属部门名称")
    private String taskDepartmentName;

    @ApiModelProperty(value = "是否逾期：0-未逾期，1-已逾期")
    private Integer isOverdue;

    @ApiModelProperty(value = "是否逾期名称：未逾期/已逾期")
    private String isOverdueName;

    // 任务关联 表单
    private List<EmployeeTaskFormItemDetailVO> formItemList;
    /**
     * 表单中有无设置关联（0无/1是）
     */
    private Integer hasAnyRelate;

    // 任务关联公告
    private EmployeeAnnouncementsDetailVO announcementsDetailVO;
}
