package com.tll.housekeeper.rpc.param.resp;

import com.tll.housekeeper.rpc.param.resp.enums.AuditStatusEnum;
import com.tll.housekeeper.rpc.param.resp.enums.OperationTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
public class OperationLogVO implements Serializable {
    
    @ApiModelProperty("主键id")
    Long id;

    @ApiModelProperty("任务唯一标识符")
    private String taskId;

    @ApiModelProperty("任务类型（1: 门店任务，2: 员工任务）")
    private Integer taskType;

    @ApiModelProperty("日志记录时间")
    private LocalDateTime logTime;

    @ApiModelProperty("操作人姓名")
    private String operator;

    @ApiModelProperty("操作类型：1-提交，2-审核，3-驳回，4-阅读，5-撤销")
    private Integer operationType;

    @ApiModelProperty("任务名称")
    private String taskName;


    @ApiModelProperty("审核状态")
    private Integer auditStatus;

    @ApiModelProperty("驳回原因（若无则为 NULL）")
    private String rejectionReason;

    @ApiModelProperty("备注（若无则为 NULL）")
    private String remark;

    @ApiModelProperty("存储完整的表单内容，JSON 格式")
    private String dataRemark;

    @ApiModelProperty("格式化后的日志文本内容")
    private String formattedLog;


    public void generateFormattedLog() {
        StringBuilder logBuilder = new StringBuilder();

        // 添加操作员信息
        logBuilder.append(operator);

        // 添加操作类型的描述
        if (operationType != null) {
            try {
                // 通过描述获取枚举实例
                OperationTypeEnum opTypeEnum = OperationTypeEnum.getByCode(operationType);
                logBuilder.append(opTypeEnum == null ? "" : opTypeEnum.getDescription());
            } catch (IllegalArgumentException e) {
                logBuilder.append("未知操作");
            }
        } else {
            logBuilder.append("未知操作");
        }

        // 根据操作类型添加具体内容
        if (OperationTypeEnum.AUDIT.equals(OperationTypeEnum.getByCode(operationType))) {
            logBuilder.append("了任务“").append(taskName).append("”，审核状态为“");

            if (auditStatus != null) {
                try {
                    AuditStatusEnum auditStatusEnum = AuditStatusEnum.getByCode(auditStatus);
                    logBuilder.append(auditStatusEnum == null ? "" : auditStatusEnum.getDescription()).append("”");
                } catch (IllegalArgumentException e) {
                    logBuilder.append("未知状态”");
                }
            } else {
                logBuilder.append("未知状态”");
            }

            // 处理审核状态
            if (AuditStatusEnum.REJECTED.equals(AuditStatusEnum.getByCode(auditStatus)) && rejectionReason != null) {
                logBuilder.append("，驳回原因为：").append(rejectionReason);
            }
        } else {
            logBuilder.append("了任务“").append(taskName).append("”");
            if (remark != null && !remark.isEmpty()) {
                logBuilder.append("，备注为：").append(remark);
            }
        }

        // 将格式化后的日志内容赋值给 formattedLog
        this.formattedLog = logBuilder.toString();
    }



}
