package com.tll.housekeeper.rpc.param.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
public class StoreAnnouncementsDetailVO implements Serializable {
    @ApiModelProperty(value = "门店公告任务id")
    private Long id;

    @ApiModelProperty(value = "公告名称")
    private String name;

    @ApiModelProperty(value = "公告所属部门名称")
    private String departmentName;

    @ApiModelProperty(value = "公告所属部门编码")
    private String departmentCode;

    @ApiModelProperty(value = "公告内容")
    private String content;

    @ApiModelProperty(value = "是否使用公告操作 0：无操作 1：1个按钮 2：两个按钮")
    private Integer actionType;

    @ApiModelProperty(value = "按钮文字1")
    private String actionButton;

    @ApiModelProperty(value = "按钮文字2")
    private String actionButtonTwo;

    @ApiModelProperty(value = "选项内容  1：按钮1   2：按钮2")
    private Integer optionValue;


    public StoreAnnouncementsDetailVO(Long id, String name, String departmentName, String departmentCode, String content,
                                      Integer actionType, String actionButton, String actionButtonTwo, Integer optionValue) {
        this.id = id;
        this.name = name;
        this.departmentName = departmentName;
        this.departmentCode = departmentCode;
        this.content = content;
        this.actionType = actionType;
        this.actionButton = actionButton;
        this.actionButtonTwo = actionButtonTwo;
        this.optionValue = optionValue;
    }
}
