package com.tll.housekeeper.rpc.param.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "门店任务信息")
public class StoreTaskDetailVO implements Serializable{
    private static final long serialVersionUID = -1L;

    @ApiModelProperty(value = "主任务Id")
    private String taskId;
    @ApiModelProperty(value = "门店任务Id")
    private String storeTaskId;
    @ApiModelProperty(value = "任务名称")
    private String taskName;
    @ApiModelProperty("任务内容 1:指定表单 2:指定公告")
    private String taskNote;
    @ApiModelProperty(value = "任务备注说明")
    private String taskRemark;
    @ApiModelProperty(value = "门店任务状态  0：待提交   1：已完成   2：已回收  3：已过期  4：整改中 5：待审核   6：审核中   7：待整改 8：已失效")
    private Integer taskState;
    @ApiModelProperty(value = "门店任务状态名")
    private String taskStateStr;
    @ApiModelProperty(value = "门店编码")
    private String storeCoding;
    @ApiModelProperty(value = "门店名称")
    private String storeName;
    @ApiModelProperty(value = "法人")
    private String legalPerson;
    @ApiModelProperty(value = "法人手机号")
    private String legalPersonPhone;
    @ApiModelProperty(value = "门店地址")
    private String storeAddress;
    @ApiModelProperty(value = "计划执行人")
    private String planExecutor;
    @ApiModelProperty(value = "实际执行人")
    private String realExecutor;
    @ApiModelProperty(value = "计划执行角色")
    private String PlanExecutorRole;
    @ApiModelProperty(value = "实际执行人角色")
    private String realExecutorRole;
    @ApiModelProperty(value = "查阅状态  0：未查阅  1：已查阅")
    private Integer isRead;
    @ApiModelProperty(value = "南北战区")
    private String region;
    @ApiModelProperty(value = "大区经理")
    private String bigRegionalManager;
    @ApiModelProperty(value = "省经理")
    private String provinceManager;
    @ApiModelProperty(value = "区域经理")
    private String regionalManager;
    @ApiModelProperty(value = "任务创建人")
    private String creator;
    @ApiModelProperty(value = "任务创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty(value = "任务开始时间")
    private LocalDateTime beginTime;
    @ApiModelProperty(value = "任务结束时间")
    private LocalDateTime endTime;
    @ApiModelProperty(value = "实际执行时间")
    private LocalDateTime realEndTime;
    @ApiModelProperty(value = "最近一次任务编辑人")
    private String updater;
    @ApiModelProperty(value = "任务编辑时间")
    private LocalDateTime modifyTime;
    @ApiModelProperty(value = "撤销状态 0：未撤销 1：已撤销")
    private Integer isBack;
    @ApiModelProperty(value = "催办状态 0：未催办 1：已催办")
    private Integer urgeState;
    

    // 任务关联 表单
    private List<StoreTaskFormItemDetailVO> formItemList;

    // 任务关联公告
    private StoreAnnouncementsDetailVO announcementsDetailVO;


}
