package com.tll.housekeeper.rpc.param.resp;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.List;

/**
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
public class StoreTaskFormItemDetailVO implements Serializable {


    /** 记录唯一ID */
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    @Comment("所属表单记录id")
    @Column(nullable = false)
    private Long storeTaskRecordId;


    @Comment("排序号")
    @Column(nullable = false)
    private int sort;

    @Comment("表单项类型：1-单选，2-多选，3-下拉框，4-图片，5-视频，6-文本框，7-量表题，8-定位，9-地址，10-日期，11-门店，12-长文本")
    @Column(nullable = false)
    private int type;

    @Comment("标题")
    @Column(nullable = false, length = 128)
    private String title;

    @Comment("填写提示")
    @Column(length = 128)
    private String hint;

    @Comment("是否必填：0-否，1-是")
    @Column(nullable = false, columnDefinition = "int default 0")
    private int isRequired;

    @Comment("是否有填写提示：0-否，1-是")
    @Column(nullable = false, columnDefinition = "int default 0")
    private int isRemind;

    @Comment("图片是否添加水印：0-否，1-是")
    @Column(columnDefinition = "int default null")
    private Integer isImgWatermark;

    @Comment("图片必需数量")
    @Column(columnDefinition = "int default null")
    private Integer imgNumber;

    @Comment("图片上传规则：0-不限，1-仅限拍照上传")
    @Column(columnDefinition = "int default null")
    private Integer imgUploadRule;

    @Comment("视频必需数量")
    @Column(columnDefinition = "int default null")
    private Integer videoNumber;

    @Comment("定位是否允许修改：0-否，1-是")
    @Column(columnDefinition = "int default null")
    private Integer isModifyLocation;

    @Comment("是否为起止日期：0-否，1-是")
    @Column(columnDefinition = "int default null")
    private Integer isRangeDate;

    @Comment("地址层级：1-省市区详细地址，2-省市区，3-省市，4-省")
    @Column(columnDefinition = "int default null")
    private Integer addressLevel;

    @Comment("量表等级")
    @Column(columnDefinition = "int default null")
    private Integer scaleLevel;

    @Comment("描述显示模式")
    @ApiModelProperty(value = "描述显示模式")
    private Integer describeShowMode;

    @Comment("描述内容类型")
    @ApiModelProperty(value = "描述内容类型")
    private Integer describeContentType;

    @Comment("描述内容")
    @ApiModelProperty(value = "描述内容")
    private String describeContent;

    @Comment("关联选项ID列表")
    @ApiModelProperty(value = "关联选项ID列表")
    private List<Long> relateOptionId;

    List<StoreTaskItemOptionDetailVO> optionsList;
    @ApiModelProperty("前端展示用,拼接字符串")
    String selectValue;
}
