package com.tll.housekeeper.rpc.param.resp;

import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.List;

/**
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
public class StoreTaskItemOptionDetailVO implements Serializable {

    @Comment("记录唯一ID")
    @Column
    private Long id;

    @Comment("所属表单项id")
    @Column(nullable = false)
    private long formItemId;

    @Comment("排序号")
    @Column(nullable = false)
    private int sort;

    @Comment("选项内容")
    @Column(length = 16)
    private String content;


    @Comment("表单项对应选项或值")
    @Column(length = 255)
    private String optionValue;

    @Comment("量表分值")
    @Column(columnDefinition = "int default null")
    private Integer levelNum;

    @Comment("关联表单项ID列表")
    private List<Long> relateFormItemIds;

}
