package com.tll.housekeeper.rpc.param.resp.enums;

import cn.hutool.core.util.StrUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 权限类型枚举
 *
 * @author zhangzhaolong
 */
@Getter
@AllArgsConstructor
public enum MemberPermissionTypeEnum {
    UNKNOWN("-1", "未知"),
    SUPERVISOR("0", "督导"),
    REGIONAL_MANAGER("1", "区域经理"),
    GENERAL_REGIONAL_MANAGER("2", "大区经理"),
    MARKETING_DIRECTOR("3", "市场总"),;

    private final String code;
    private final String description;

    /**
     * 根据code获取枚举
     */
    public static String getByCode(String code) {
        if (StrUtil.isBlank(code)) {
            return MemberPermissionTypeEnum.SUPERVISOR.getCode();
        }
        for (MemberPermissionTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type.getCode();
            }
        }
        return MemberPermissionTypeEnum.SUPERVISOR.getCode();
    }

    public static MemberPermissionTypeEnum getEnumByCode(String code) {
        if (StrUtil.isBlank(code)) {
            return MemberPermissionTypeEnum.UNKNOWN;
        }
        for (MemberPermissionTypeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return UNKNOWN;
    }
}