package com.tll.housekeeper.rpc.param.resp.enums;

import lombok.Getter;

/**
 * 操作类型枚举
 *
 * @author Jxinx
 * @date 2024-09-19
 */
@Getter
public enum OperationTypeEnum {
    SUBMIT(1, "提交"),
    AUDIT(2, "审核"),
    REJECT(3, "驳回"),
    READ(4, "阅读"),
    CANCEL(5, "撤销");

    private final Integer code;
    private final String description;

    OperationTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 根据code获取枚举项
     */
    public static OperationTypeEnum getByCode(Integer code) {
        for (OperationTypeEnum typeEnum : OperationTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 通过 description 获取枚举实例
     */
    public static OperationTypeEnum fromDescription(String description) {
        for (OperationTypeEnum type : OperationTypeEnum.values()) {
            if (type.getDescription().equals(description)) {
                return type;
            }
        }
        throw new IllegalArgumentException("没有匹配的操作类型: " + description);
    }
}
