package com.tll.housekeeper.rpc.param.resp.enums;

/**
 * @author  XieBeiChen
 * @date  2025-05-23 11:59
 * @description 门店类型枚举类
 */
public enum StoreType {
    FRANCHISE(1, "加盟店"),
    COMPANY_OWNED(0, "直营店");

    private final int code;
    private final String description;

    StoreType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据编码获取对应的枚举值
     *
     * @param code 枚举编码
     * @return 对应的 StoreType
     */
    public static StoreType fromCode(int code) {
        for (StoreType storeType : values()) {
            if (storeType.getCode() == code) {
                return storeType;
            }
        }
        throw new IllegalArgumentException("未知的门店类型编码：" + code);
    }
}
