package com.tll.housekeeper.rpc.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.List;

/**
 * 发起审核响应数据
 *
 * @author Jxinx
 * @since 2025-05-08
 */
@Data
@ApiModel(description = "发起审核响应数据")
public class BreachRefundSubmitRpcVO implements Serializable {



    @ApiModelProperty(value = "流程实例Id")
    private String procInstld;

    @ApiModelProperty("业务主键")
    private String businessKey;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")
    private String procInstStatus;

    @ApiModelProperty("审批人信息")
    private List<ApproveInfoVO> approveList;

    @Data
    public static class ApproveInfoVO {
        @ApiModelProperty(value = "审批人ID")
        private Long approveId;

        @ApiModelProperty(value = "审批人姓名")
        private String approveFullName;

        @ApiModelProperty(value = "审批人电话")
        private String approvePhone;
    }
}
