package com.tll.housekeeper.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Data;

/**
 * 统一返回.
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "统一返回")
public class WorkFlowRpcVO implements Serializable {

    @ApiModelProperty(value = "发起人用户ID")
    private Long userId;

    @ApiModelProperty(value = "流程ID")
    private String procInstId;

    @ApiModelProperty(value = "业务主键")
    private String businessKey;

    @ApiModelProperty(value = "流程状态")
    private String procInstStatus;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty(value = "流程评论")
    private String comment;

    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "所属租户ID")
    private Long tenantId;

    @ApiModelProperty(value = "所属组织ID")
    private Long belongOrgId;

    @ApiModelProperty(value = "租户组织ID")
    private Long tenantOrgId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "记录创建者ID")
    private Long createUserId;

    @ApiModelProperty(value = "记录创建者")
    private String creator;

    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty(value = "记录最后更新者")
    private String updater;

    @ApiModelProperty(value = "记录最后更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "删除标记")
    private Integer deleteFlag;

    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty(value = "数据归属组织id", hidden = true)
    private Long secBuId;

    @ApiModelProperty(value = "数据归属雇员id", hidden = true)
    private Long secUserId;

    @ApiModelProperty(value = "数据归属公司id", hidden = true)
    private Long secOuId;
}
