package com.tll.inspect.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import lombok.Data;

/**
 * 员工列表响应实体数据
 *
 * @author Jxinx
 * @date 2024-11-20
 */
@Data
@ApiModel(description = "员工列表响应实体数据")
public class EmployeePageRespVO implements Serializable {

    private static final long serialVersionUID = -4078871217932564312L;

    /**
     * 员工用户ID
     */
    @ApiModelProperty(value = "员工用户ID")
    private Long userId;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工编号")
    private String code;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private String fullName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别")
    private String genderName;

    /**
     * 职务
     */
    @ApiModelProperty(value = "职务")
    private String duty;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String email;

    /**
     * 所在组织
     */
    @ApiModelProperty(value = "所在组织")
    private String orgName;

    /**
     * 完整组织名称
     */
    @ApiModelProperty(value = "完整组织名称")
    private String fullOrgName;

    /**
     * 战区
     */
    @ApiModelProperty(value = "战区")
    private String warZone;

    @ApiModelProperty(value = "用户状态:true在职，false，离职")
    private Boolean enabled;

    @ApiModelProperty(value = "门店列表集合")
    private List<String> storeCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EmployeePageRespVO that = (EmployeePageRespVO) o;
        return Objects.equals(userId, that.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userId);
    }

}
